<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

requireLogin();
header('Content-Type: application/json');

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Invoice ID is required']);
    exit();
}

$invoice_id = intval($_GET['id']);

try {
    // Get invoice details
    $stmt = $pdo->prepare("
        SELECT 
            i.*,
            c.name as customer_name,
            c.email as customer_email,
            c.phone as customer_phone,
            c.address as customer_address,
            u.username as created_by_name,
            COALESCE(q.quote_number, '') as quotation_reference
        FROM invoices i
        LEFT JOIN customers c ON i.customer_id = c.id
        JOIN users u ON i.created_by = u.id
        LEFT JOIN quotations q ON i.quotation_id = q.id
        WHERE i.id = ?
    ");
    $stmt->execute([$invoice_id]);
    $invoice = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$invoice) {
        echo json_encode(['success' => false, 'message' => 'Invoice not found']);
        exit();
    }

    // Get invoice items
    $stmt = $pdo->prepare("
        SELECT 
            ii.*,
            p.name as product_name,
            p.description as product_description
        FROM invoice_items ii
        JOIN products p ON ii.product_id = p.id
        WHERE ii.invoice_id = ?
        ORDER BY ii.id
    ");
    $stmt->execute([$invoice_id]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'invoice' => $invoice,
        'items' => $items
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching invoice details: ' . $e->getMessage()
    ]);
} 